/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.SelfSignedServerCert;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NewServerCertBean
extends PanelBean
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTNEWD";
    private static final String TRACE_MASKF = "XCRTNEWF";
    private static final String TRACE_MASKT = "XCRTNEWT";
    private static final String LIST_SEPARATOR = " - ";
    private ServerCert originalCertificate = null;
    private boolean selfSigned;
    private String m_sIntroLabel;
    private String m_sOrganization;
    private String m_sOrganizationUnit;
    private String m_sCountry;
    private ValueDescriptor[] m_vdCountry;
    private String m_sState;
    private ValueDescriptor[] m_vdState;
    private String m_sLocality;
    private String m_sNumberOfDaysValid;
    private String m_sEMailAddr;
    String countryCode = null;

    public NewServerCertBean(ServerCert certificate, String name, boolean selfSigned) {
        this.originalCertificate = certificate;
        this.selfSigned = selfSigned;
        this.setBeanName(name);
        this.countryCode = "";
        Trace.trace(TRACE_MASKT, "<->NewServerCertBean(" + certificate + ", " + name + ", " + selfSigned + ")");
    }

    public void setIntroLabel(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setIntroLabel(" + s + ")");
        this.m_sIntroLabel = s;
    }

    public String getIntroLabel() {
        Trace.trace(TRACE_MASKT, "<->getIntrolLabel() returning " + this.m_sIntroLabel);
        return this.m_sIntroLabel;
    }

    public void setOrganization(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setOrganization(" + s + ")");
        this.m_sOrganization = s;
    }

    public String getOrganization() {
        Trace.trace(TRACE_MASKT, "<->getOrganization() returning " + this.m_sOrganization);
        return this.m_sOrganization;
    }

    public void setOrganizationUnit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setOrganizationUnit(" + s + ")");
        this.m_sOrganizationUnit = s;
    }

    public String getOrganizationUnit() {
        Trace.trace(TRACE_MASKT, "<->getOrganizationUnit() returning " + this.m_sOrganizationUnit);
        return this.m_sOrganizationUnit;
    }

    public ValueDescriptor[] getCountryList() {
        Trace.trace(TRACE_MASKT, "<->getCountryList() returning " + this.m_vdCountry);
        return this.m_vdCountry;
    }

    public void setCountry(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setCountry(" + s + ")");
        if (s.length() == 2) {
            this.countryCode = s;
        } else {
            this.countryCode = this.getCountryCode(s);
            if (this.countryCode == null) {
                throw new IllegalUserDataException(new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0060").toString());
            }
        }
        this.m_sCountry = s;
        this.setStateList(this.countryCode, null, true);
    }

    private void setCountryAndStateList(String countryCode, String countryEntryLine, String preSelectedState) {
        Trace.trace(TRACE_MASKT, "<->setCountryAndStateList(" + countryCode + ", " + countryEntryLine + ", " + preSelectedState + ")");
        this.countryCode = countryCode;
        this.m_sCountry = countryEntryLine;
        this.setStateList(countryCode, preSelectedState, false);
    }

    public String getCountry() {
        Trace.trace(TRACE_MASKT, "<->getCountry() returning " + this.m_sCountry);
        return this.m_sCountry;
    }

    public ValueDescriptor[] getStateList() {
        Trace.trace(TRACE_MASKT, "<->getStateList() returning " + this.m_vdState);
        return this.m_vdState;
    }

    public void setState(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setState(" + s + ")");
        this.m_sState = s;
    }

    public String getState() {
        Trace.trace(TRACE_MASKT, "<->getState() returning " + this.m_sState);
        return this.m_sState;
    }

    public void setLocality(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setLocality(" + s + ")");
        this.m_sLocality = s;
    }

    public String getLocality() {
        Trace.trace(TRACE_MASKT, "<->getLocality() returning " + this.m_sLocality);
        return this.m_sLocality;
    }

    public void setNumberOfDaysValid(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setNumberOfDaysValid(" + s + ")");
        this.m_sNumberOfDaysValid = String.valueOf(CertMgtPanelUtils.parseNumOfDays(s));
    }

    public String getNumberOfDaysValid() {
        Trace.trace(TRACE_MASKT, "<->getNumberOfDaysValid() returning " + this.m_sNumberOfDaysValid);
        return this.m_sNumberOfDaysValid;
    }

    public void setEMailAddr(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setEMailAddr(" + s + ")");
        this.m_sEMailAddr = s;
    }

    public String getEMailAddr() {
        Trace.trace(TRACE_MASKT, "<->getEMailAddr() returning " + this.m_sEMailAddr);
        return this.m_sEMailAddr;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        CertPrincipal subject = null;
        Trace.trace(TRACE_MASKT, "->load()");
        if (this.originalCertificate == null) {
            this.m_sIntroLabel = this.selfSigned ? new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "newSelfSignedCertIntroLabel").toString() : new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "newCASignedCertIntroLabel").toString();
        } else {
            this.m_sIntroLabel = new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "modifyCertIntroLabel").toString();
            subject = this.originalCertificate.getSubject();
            if (subject != null) {
                this.m_sOrganization = subject.getOrg() != null ? subject.getOrg() : "";
                this.m_sOrganizationUnit = subject.getOrgUnit() != null ? subject.getOrgUnit() : "";
                this.m_sLocality = subject.getLocality() != null ? subject.getLocality() : "";
                this.m_sEMailAddr = subject.getEMailAddr() != null ? subject.getEMailAddr() : "";
                this.setCountryListAndStateList(subject.getCountry(), subject.getState());
                this.m_sNumberOfDaysValid = "";
            }
        }
        if (this.originalCertificate == null || subject == null) {
            this.m_sOrganization = "";
            this.m_sOrganizationUnit = "";
            this.m_sCountry = "";
            this.m_sState = "";
            this.m_sLocality = "";
            this.m_sEMailAddr = "";
            this.m_sNumberOfDaysValid = "";
            this.setCountryListAndStateList(this.getDefaultCountryCode(), null);
        }
        Trace.trace(TRACE_MASKT, "<-load()");
    }

    public void prepare() {
        UserTaskManager utm = null;
        CertPrincipal subject = null;
        Trace.trace(TRACE_MASKT, "->prepare()");
        utm = this.getUserTaskManager();
        if (utm != null && this.originalCertificate != null && (subject = this.originalCertificate.getSubject()) != null) {
            utm.setShown(this.getMountPrefix() + "NumberOfDaysValidEntry", false);
            utm.setShown(this.getMountPrefix() + "String9", false);
        }
        Trace.trace(TRACE_MASKT, "<-prepare()");
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        block13: {
            String elementName;
            block14: {
                CertPrincipal modifiedSubject;
                String eMailAddr;
                String locality;
                String state;
                String country;
                String organizationUnit;
                String organization;
                block17: {
                    String action;
                    SelfSignedServerCert partialServerCert;
                    String numOfDaysValid;
                    UserTaskManager utm;
                    block16: {
                        block15: {
                            elementName = null;
                            String actionCommand = null;
                            utm = null;
                            organization = null;
                            organizationUnit = null;
                            country = null;
                            state = null;
                            locality = null;
                            numOfDaysValid = null;
                            eMailAddr = null;
                            partialServerCert = null;
                            action = null;
                            modifiedSubject = null;
                            Trace.trace(TRACE_MASKT, "->panelAction(" + event + ")");
                            if (event == null) break block13;
                            Trace.trace(TRACE_MASKF, "Bean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
                            elementName = event.getElementName();
                            actionCommand = event.getActionCommand();
                            utm = this.getUserTaskManager();
                            if (!actionCommand.equals("NewServerCertOKButton")) break block14;
                            if (utm != null) {
                                utm.storeAllElements();
                            }
                            organization = this.trimEntryField(this.getOrganization());
                            organizationUnit = this.trimEntryField(this.getOrganizationUnit());
                            country = this.trimEntryField(this.countryCode);
                            state = this.trimEntryField(this.getState());
                            locality = this.trimEntryField(this.getLocality());
                            numOfDaysValid = this.trimEntryField(this.getNumberOfDaysValid());
                            eMailAddr = this.trimEntryField(this.getEMailAddr());
                            if (organization != null && organizationUnit != null && country != null && state != null && locality != null && (this.originalCertificate != null || numOfDaysValid != null)) break block15;
                            if (utm != null) {
                                try {
                                    CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0017"), MsgType.ERROR_MESSAGE);
                                }
                                catch (HException e) {
                                    new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                                }
                            }
                            break block13;
                        }
                        if (country.length() == 2) break block16;
                        if (utm != null) {
                            try {
                                CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0018"), MsgType.ERROR_MESSAGE);
                            }
                            catch (HException e) {
                                new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                            }
                        }
                        break block13;
                    }
                    if (this.originalCertificate != null) break block17;
                    partialServerCert = new SelfSignedServerCert(new Integer(numOfDaysValid), country, state, locality, organization, organizationUnit, null, eMailAddr, null, null, false);
                    try {
                        action = this.selfSigned ? "finishSelfSignedServerCert" : "finishCASignedServerCert";
                        CertMgtPanelUtils.sendTaskletRequest(action, partialServerCert, null, null, this);
                    }
                    catch (NumberFormatException e) {
                        if (utm == null) break block13;
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0007"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0019"), MsgType.ERROR_MESSAGE);
                            break block13;
                        }
                        catch (HException e2) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e2).log();
                        }
                    }
                    break block13;
                }
                modifiedSubject = new CertPrincipal(country, state, locality, organization, organizationUnit, this.originalCertificate.getSubject().getHostName(), eMailAddr);
                CertMgtPanelUtils.sendTaskletRequest("finishSubject", modifiedSubject, null, this.originalCertificate, this);
                break block13;
            }
            if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }

    private String trimEntryField(String s) {
        String result = null;
        if (s != null && (result = s.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    private String makeDisplayableLine(DisplayableCountry country) {
        if (country != null) {
            return country.getIsoCode() + LIST_SEPARATOR + country.getDescription();
        }
        return "";
    }

    private String makeDisplayableCountryLine(String country) {
        if (country != null) {
            return country + LIST_SEPARATOR;
        }
        return "";
    }

    private String makeDisplayableLine(DisplayableSubdivision subdivision) {
        if (subdivision != null) {
            return subdivision.getDescription();
        }
        return "";
    }

    private String getCountryCode(String s) {
        String result = null;
        if (s != null && s.length() >= 2 + LIST_SEPARATOR.length() && s.substring(2).startsWith(LIST_SEPARATOR)) {
            result = s.substring(0, 2);
        }
        Trace.trace(TRACE_MASKT, "<->getCountryCode(" + s + ") returning " + result);
        return result;
    }

    private void setCountryListAndStateList(String preSelectedCountry, String preSelectedState) {
        List countriesList = null;
        DisplayableCountry country = null;
        String entry = null;
        boolean preSelectionDone = false;
        ValueDescriptor[] tempCountry = null;
        Trace.trace(TRACE_MASKT, "->setCountryListAndStateList(" + preSelectedCountry + ", " + preSelectedState + ")");
        countriesList = ConnectionInfoManager.getConnectionInfoManager().getDisplayableCountries(Locale.getDefault());
        if (countriesList != null && countriesList.size() > 0) {
            this.m_vdCountry = new ValueDescriptor[countriesList.size()];
            preSelectionDone = preSelectedCountry == null || preSelectedCountry.length() == 0;
            for (int i = 0; i < countriesList.size(); ++i) {
                country = (DisplayableCountry)countriesList.get(i);
                entry = this.makeDisplayableLine(country);
                this.m_vdCountry[i] = CertMgtPanelUtils.createValueDescriptor("Country", entry);
                if (preSelectionDone || !preSelectedCountry.equals(country.getIsoCode())) continue;
                this.setCountryAndStateList(preSelectedCountry, entry, preSelectedState);
                preSelectionDone = true;
            }
            if (!preSelectionDone) {
                tempCountry = new ValueDescriptor[countriesList.size() + 1];
                entry = this.makeDisplayableCountryLine(preSelectedCountry);
                tempCountry[0] = CertMgtPanelUtils.createValueDescriptor("Country", entry);
                System.arraycopy(this.m_vdCountry, 0, tempCountry, 1, countriesList.size());
                this.m_vdCountry = tempCountry;
                this.setCountryAndStateList(preSelectedCountry, entry, preSelectedState);
            } else if (preSelectedCountry == null || preSelectedCountry.length() == 0) {
                country = (DisplayableCountry)countriesList.get(0);
                entry = this.makeDisplayableLine(country);
                this.setCountryAndStateList(country.getIsoCode(), entry, preSelectedState);
            }
        } else {
            this.m_vdCountry = new ValueDescriptor[0];
            this.countryCode = "";
            this.m_sCountry = "";
            this.m_vdState = new ValueDescriptor[0];
            this.m_sState = "";
        }
        Trace.trace(TRACE_MASKT, "<-setCountryListAndStateList(...)");
    }

    private void setStateList(String preSelectedCountry, String preSelectedState, boolean refreshUTM) {
        Map countriesSupported = null;
        List subdivisions = null;
        String countryWithSubdivisions = null;
        DisplayableSubdivision state = null;
        String entry = null;
        UserTaskManager utm = null;
        boolean preSelectionDone = false;
        ValueDescriptor[] tempState = null;
        Trace.trace(TRACE_MASKT, "->setStateList(" + preSelectedCountry + ", " + preSelectedState + ", " + refreshUTM + ")");
        this.m_vdState = new ValueDescriptor[0];
        this.setState("");
        if (preSelectedCountry != null && preSelectedCountry.length() > 0 && (countriesSupported = ConnectionInfoManager.getConnectionInfoManager().getDisplayableSubdivisions(Locale.getDefault())) != null) {
            Iterator i = countriesSupported.keySet().iterator();
            while (i.hasNext()) {
                countryWithSubdivisions = (String)i.next();
                if (!preSelectedCountry.equals(countryWithSubdivisions)) continue;
                subdivisions = (List)countriesSupported.get(countryWithSubdivisions);
                if (subdivisions == null || subdivisions.size() <= 0) break;
                this.m_vdState = new ValueDescriptor[subdivisions.size()];
                preSelectionDone = preSelectedState == null || preSelectedState.length() == 0;
                for (int j = 0; j < subdivisions.size(); ++j) {
                    state = (DisplayableSubdivision)subdivisions.get(j);
                    entry = this.makeDisplayableLine(state);
                    this.m_vdState[j] = CertMgtPanelUtils.createValueDescriptor("State", entry);
                    if (preSelectionDone || !preSelectedState.equals(entry)) continue;
                    this.setState(entry);
                    preSelectionDone = true;
                }
                if (!preSelectionDone) {
                    tempState = new ValueDescriptor[subdivisions.size() + 1];
                    entry = preSelectedState;
                    tempState[0] = CertMgtPanelUtils.createValueDescriptor("State", entry);
                    System.arraycopy(this.m_vdState, 0, tempState, 1, subdivisions.size());
                    this.m_vdState = tempState;
                    this.setState(entry);
                    break;
                }
                if (preSelectedState != null && preSelectedState.length() != 0) break;
                state = (DisplayableSubdivision)subdivisions.get(0);
                entry = this.makeDisplayableLine(state);
                this.setState(entry);
                break;
            }
        }
        if (refreshUTM && (utm = this.getUserTaskManager()) != null) {
            utm.refreshElement(this.getMountPrefix() + "State");
        }
        Trace.trace(TRACE_MASKT, "<-setStateList(...)");
    }

    private String getDefaultCountryCode() {
        CustomerInfoManager custInfoMgr = null;
        CustomerInfoData custInfo = null;
        String result = null;
        custInfoMgr = CustomerInfoManager.getCustomerInfoManager();
        if (custInfoMgr != null && (custInfo = custInfoMgr.getCustomerInfo()) != null && (result = custInfo.getSystemCountryCode()) != null && result.length() == 2) {
            return result;
        }
        result = Locale.getDefault().getCountry();
        if (result.length() != 2) {
            result = "US";
        }
        return result;
    }
}

